#!/bin/sh

ULOGFILE=ulogd.syslogemu
DATE=`date +%Y-%m-%d`
DATE_3DAYS=`date --date '4 days ago' "+%Y-%m-%d"`
ULOGDAEMON=`find /usr/local/ -name ulogd | grep sbin`
LOGDIR=fwlogs

if [ ! -d /var/log/$LOGDIR ];then
/bin/mkdir /var/log/$LOGDIR
fi

if [ ! -f /usr/local/sbin/ulogd ];then
/bin/ln -s $ULOGDAEMON /usr/local/sbin/ulogd
fi

if [ -f /var/log/$LOGDIR/ulogd.syslogemu-$DATE_3DAYS.tgz ];then
/bin/rm /var/log/$LOGDIR/ulogd.syslogemu-$DATE_3DAYS.tgz
fi

if [ -f /var/log/$ULOGFILE ];then

tar zcf /var/log/$LOGDIR/$ULOGFILE-$DATE.tgz /var/log/$ULOGFILE
rm /var/log/$ULOGFILE
touch /var/log/$ULOGFILE && chmod o+w /var/log/$ULOGFILE

killall ulogd && sleep 5 && /usr/local/ulogd/sbin/ulogd -d 2>&1

fi

exit 0
