#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

echo "
Installing $PROG_NAME
"

if [ -d /usr/local/ulogd ] ; then
	rm -rf /usr/local/ulogd
fi

wget -q --directory-prefix=/usr/local/src/AdminInstall/src/. http://212.43.241.29/AdminInstall_Src/ulogd-1.02.tar.gz

ULOGD_TGZ=`find $OAT_SRC -iname ulogd\*gz | awk -F/ '{ print $7; }'`

echo "
Installation of $PROG_NAME in progress, please wait ...
"

echo -e '* Extracting...\033[0m
'
tar xzf $OAT_SRC/$ULOGD_TGZ -C /usr/local/src

ULOGD_REP=`find $OAT_SRC -iname ulogd\*gz | awk -F/ '{ print $7; }' | sed -e "s/\.tar.*$//"`

cd /usr/local/src/$ULOGD_REP

echo -e '* Compiling...\033[0m
'
./configure --prefix=/usr/local/ulogd
make
make install

echo "/usr/local/ulogd/lib/ulogd" >> /etc/ld.so.conf && ldconfig

/bin/ln -s /usr/local/ulogd/sbin/ulogd /usr/local/sbin/ulogd

echo -e '* Doing required actions...\033[0m
'
/bin/mkdir /var/log/fwlogs

/bin/cp $OAT_CONF/ulogd/logrotate_ulogd.sh /usr/local/libexec/.
/bin/cp -f $OAT_CONF/ulogd/ulogd.conf /usr/local/ulogd/etc/.

echo "
# ulogd logrotate (/var/log/ulogd.syslogemu)
30 04 * * 7 root /usr/local/libexec/logrotate_ulogd.sh" >> /etc/crontab

/bin/cp $OAT_CONF/ulogd/logrotate_ulogd.sh /usr/local/libexec/.

echo -e '* \033[32mSetting up run-levels...\033[0m
'

/bin/cp $OAT_CONF/ulogd/ulogd_init /etc/init.d/ulogd

/usr/sbin/update-rc.d -f ulogd defaults

echo -e '* \033[32mResetting IPTABLES rules...\033[0m'
iptables -F
iptables-restore $OAT_CONF/netfilter/iptables.rules.ulogd

cp $OAT_CONF/netfilter/iptables.rules.ulogd /etc/iptables.rules

echo "pre-up iptables-restore < /etc/iptables.rules" >> /etc/network/interfaces

	echo -en '*** a copy of iptables.rules file has been made in /etc ***
	'

/etc/init.d/ulogd start


echo "ULOGD = 1" >> /root/install_report

exit 0
