#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

echo "
Installation of Tomcat in progress, please wait...
"

echo -e '* \033[32mDownloading...\033[0m'
wget -q --directory-prefix=/usr/local/src/. http://212.43.241.29/AdminInstall_Src/jakarta-tomcat-4.1.31.tar.gz

echo -e '* \033[32mExtracting...\033[0m'
/bin/tar xzf /usr/local/src/jakarta-tomcat-4.1.31.tar.gz -C /usr/local/.

echo -e '* \033[32mSymlinking...\033[0m'

/bin/ln -s /usr/local/jakarta-tomcat-4.1.31 /usr/local/tomcat

echo -e '* \033[32mInstalling MySQL support for Tomcat...\033[0m'
cp -f $OAT_SRC/mm.mysql-2.0.13-bin.jar /usr/local/tomcat/common/lib/.
cp -f $OAT_SRC/mysql-connector-java-3.0.8-stable-bin.jar /usr/local/tomcat/common/lib/.

echo -e '* \033[32mCopying startup script...\033[0m'

/bin/cp -f $OAT_CONF/tomcat/init_tomcat /etc/init.d/tomcat

echo -e '* \033[32mSetting up run-levels...\033[0m'

cd /etc/init.d
/usr/sbin/update-rc.d tomcat start 91 2 3 4 5  . stop 20 0 1 6 .

echo -e '* \033[32mExporting required environment variables ...\033[0m'

echo "export CATALINA_HOME=/usr/local/tomcat" >> /etc/profile

echo "Installation of Tomcat finished successfully. Starting application ... 

"

/etc/init.d/tomcat start

echo "TOMCAT_4.1.31 = 1" >> /root/install_report

exit 0
