#!/bin/sh

. $OAT_LIBS/libYESNO.sh
. $OAT_LIBS/libRESPONSE.sh

echo "
Installation of Tomcat in progress, please wait...
"

echo -e '* \033[32mDownloading...\033[0m'
wget -q --directory-prefix=/usr/local/src/. http://212.43.241.29/AdminInstall_Src/jakarta-tomcat-5.5.9.tar.gz

echo -e '* \033[32mExtracting...\033[0m'
/bin/tar xzf /usr/local/src/jakarta-tomcat-5.5.9.tar.gz -C /usr/local/.

echo -e '* \033[32mSymlinking...\033[0m'
/bin/ln -s /usr/local/jakarta-tomcat-5.5.9 /usr/local/tomcat

# install of compat package for Tomcat 5.5.9 (provide compatibility with Tomcat 4.1.30)
promptYESNO "Do you want to install the compat package for Tomcat 5.5.9" "n"
if [ "$YESNO" = "y" ] ; then
	
	wget -q --directory-prefix=/usr/local/src/. http://212.43.241.29/AdminInstall_Src/jakarta-tomcat-5.5.9-compat.tar.gz
	echo -e '* \033[32mExtracting compat package...\033[0m'
	/bin/tar xzf /usr/local/src/jakarta-tomcat-5.5.9-compat.tar.gz -C /usr/local/.

	echo -e '* \033[32mCompat package for Tomcat 5.5.9 installed successfully\033[0m'

else 

	echo -e '* \033[32mCompat package fort Tomcat 5.5.9 will not be installed\033[0m'

fi

echo -e '* \033[32mInstalling MySQL support for Tomcat...\033[0m'
	cp -f $OAT_SRC/mm.mysql-2.0.13-bin.jar /usr/local/tomcat/common/lib/.
	cp -f $OAT_SRC/mysql-connector-java-3.0.8-stable-bin.jar /usr/local/tomcat/common/lib/.

echo -e '* \033[32mCopying startup script...\033[0m'
	/bin/cp -f $OAT_CONF/tomcat/init_tomcat /etc/init.d/tomcat

echo -e '* \033[32mSetting up run-levels...\033[0m'
	cd /etc/init.d
	/usr/sbin/update-rc.d tomcat start 91 2 3 4 5  . stop 20 0 1 6 .

echo -e '* \033[32mExporting required environment variables ...\033[0m'

	echo "export CATALINA_HOME=/usr/local/tomcat" >> /etc/profile

echo "Installation of Tomcat finished successfully."

	/etc/init.d/tomcat start

echo "

"

echo "TOMCAT_5.5.9 = 1" >> /root/install_report

exit 0
