#!/bin/sh

. $OAT_LIBS/libCHECKAPT.sh
. $OAT_LIBS/libYESNO.sh

echo "
Installing $PROG_NAME
"

CHECKAPT "$PROG_NAME"

apt-get install amavisd-new

promptYESNO "Do you want to install Spamassassin" "y"
if [ "$YESNO" = "y" ] ; then
	export PROG_NAME="Spamassassin"
	sh $OAT_SCRIPTS/mail/spamassassin/spamassassin.sh
	unset PROG_NAME
fi

AMAVIS_CONF="/etc/amavis/amavisd.conf"


if [ ! -d "/var/log/amavis" ] ; then
	mkdir /var/log/amavis
	chown -R amavis:amavis /var/log/amavis
fi

if [ ! -d "/var/virusmails" ] ; then
        mkdir /var/virusmails
        chown -R amavis:amavis /var/virusmails
fi

promptYESNO "Do you want to install Clamav" "y"
if [ "$YESNO" = "y" ] ; then
	export PROG_NAME="Clamav"
	sh $OAT_SCRIPTS/mail/clamav/clamav.sh
	unset PROG_NAME
fi

II_CLAMAV=`dpkg -l clamav-daemon | grep clamav-daemon | awk '{ print $1; }'`
II_SPAM=`dpkg -l spamassassin | grep spamassassin | awk '{ print $1; }'`

if [ "$II_CLAMAV" = "ii" -a "$II_SPAM" = "ii" ] ; then
	cp $OAT_CONF/amavisd-new/amavisd-with-spam-and-av.conf $AMAVIS_CONF
elif [ "$II_CLAMAV" = "ii" -a "$II_SPAM" != "ii" ] ; then
	cp $OAT_CONF/amavisd-new/amavisd-with-av.conf $AMAVIS_CONF
elif [ "$II_CLAMAV" != "ii" -a "$II_SPAM" = "ii" ] ; then
	cp $OAT_CONF/amavisd-new/amavisd-with-spam.conf $AMAVIS_CONF
else
	echo -e "\033[31m
	You didn't install Clamav or Spamassassin. You should install at least one
	of them and then reinstall Amavisd-new.
\033[0m"
fi

# On redclare PROG_NAME car unset plus haut
export PROG_NAME="Amavisd-new"

/etc/init.d/amavis restart

echo "/var/log/amavis/amavis.log {
		rotate 7
		daily
		compress
		delaycompress
		create 644 amavis root
		postrotate
		/etc/init.d/amavis stop > /dev/null
		sleep 10
		/etc/init.d/amavis start > /dev/null
		endscript
		}" > /etc/logrotate.d/amavis

sh $OAT_SCRIPTS/mail/amavisd-new/modify_master.sh
sh $OAT_SCRIPTS/mail/amavisd-new/modify_main.sh

postfix reload

echo "AMAVISD-NEW = 1" >> /root/install_report

echo "
Installation of $PROG_NAME finished successfully.
"
exit 0
