#!/bin/sh

. $OAT_LIBS/libCHECKAPT.sh
. $OAT_LIBS/libREMOVE.sh

echo "
Installing $PROG_NAME
"

REMOVE "$PROG_NAME"

CHECKAPT "$PROG_NAME"

echo "deb http://ftp.fr.debian.org/debian stable contrib non-free" >> /etc/apt/sources.list

apt-get update

apt-get install clamav clamav-daemon clamav-base clamav-freshclam lha unrar unarj gzip bzip2 zoo

CLAMAV_CONF="/etc/clamav/clamav.conf"

cp $OAT_CONF/clamav/clamav.conf $CLAMAV_CONF
chown -R amavis:amavis /var/run/clamav

/etc/init.d/clamav-daemon restart

echo -e '* \033[32mGet ready for Clamav configuration...\033[0m
NB: Defaults values are often OK...
'
sleep 3

dpkg-reconfigure clamav-base

sh $OAT_SCRIPTS/crons/clamav/clamav.sh

chown 108.107 /var/lib/clamav
chmod g+w /var/lib/clamav

rm /etc/cron.d/clamav-freshclam

/etc/init.d/clamav-daemon stop
/etc/init.d/clamav-daemon start

echo "CLAMAV = 1" >> /root/install_report

echo "
Installation of $PROG_NAME finished successfully.
"
exit 0
