#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

echo "
Installing $PROG_NAME
"

if [ -d /usr/local/pop-before-smtp ] ; then
	rm -rf /usr/local/pop-before-smtp
fi

echo -e '* \033[32mDownloading...\033[0m'
wget -q --directory-prefix=/usr/local/src/AdminInstall/src/. http://212.43.241.29/AdminInstall_Src/pop-before-smtp-1.36.tar.gz

PBS_TGZ=`find $OAT_SRC -iname pop-before-smtp\*gz | awk -F/ '{ print $7; }'`

echo -e '* \033[32mExtracting...\033[0m'
tar xvzf $OAT_SRC/$PBS_TGZ -C /usr/local

PBS_REP=`find $OAT_SRC -iname pop-before-smtp\*gz | awk -F/ '{ print $7; }' | sed -e "s/\.tar.*$//"`

mv /usr/local/$PBS_REP /usr/local/pop-before-smtp

echo -e '* \033[32mDoing required actions...\033[0m'
echo "/usr/local/pop-before-smtp/pop-before-smtp --config=/usr/local/pop-before-smtp/pop-before-smtp-conf.pl &" > /etc/init.d/pop-before-smtp

chmod +x /etc/init.d/pop-before-smtp

echo "
smtpd_recipient_restrictions =
	reject_non_fqdn_recipient,
	permit_mynetworks,
	check_client_access hash:/etc/postfix/pop-before-smtp,
	reject_unauth_destination" >> /etc/postfix/main.cf


echo -e '* \033[32mInstalling required Perl lib...\033[0m'
apt-get install libnet-netmask-perl libfile-tail-perl libberkeleydb-perl

echo -e '* \033[32mStarting pop-before-smtp in the background...\033[0m'
/etc/init.d/pop-before-smtp

echo "POP-BEFORE-SMTP = 1" >> /root/install_report

echo "
Installation of $PROG_NAME finished successfully.
"
exit 0
