#!/bin/sh

## Support for Quotas in Postfix

POSTFIX_ETC="/etc/postfix"

RESPONSE=`cat /root/passwd | grep POSTFIX_PASSWD | awk -F= '{ print $2; }'`

echo "

## Quotas support
virtual_create_maildirsize = yes
virtual_mailbox_extended = yes
virtual_mailbox_limit_maps = mysql:/etc/postfix/mysql_virtual_mailbox_limit_maps.cf
virtual_mailbox_limit_override = yes
virtual_maildir_limit_message = \"Sorry, the user's maildir has overdrawn his diskspace quota, please try again later.\"
virtual_overquota_bounce = yes" >> $POSTFIX_ETC/main.cf

echo "user = postfix
password = ${RESPONSE}
hosts = localhost
dbname = postfix
table = mailbox
select_field = quota
where_field = username" >> $POSTFIX_ETC/mysql_virtual_mailbox_limit_maps.cf

exit 0
