#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

CHECK_DATA=`cat /etc/mtab | grep data > /tmp/check_data_part`
if [ -s /tmp/check_data_part ];then

_DEFAULTVMAILDIR="/data/vmail"

else 
	_DEFAULTVMAILDIR="/var/vmail"
fi

VMAIL=`grep vmail /etc/passwd`
#_DEFAULTVMAILDIR="/data/vmail"

promptRESPONSE "Where would you like to store incoming mail" "$_DEFAULTVMAILDIR"

cp $OAT_CONF/postfix/master.cf /etc/postfix/master.cf

if [ "$VMAIL" != "" ] ; then
	deluser --remove-home vmail
fi

groupadd vmail
useradd -m -d $RESPONSE -g vmail vmail
chown -R vmail:vmail $RESPONSE


VMAIL_UID=`id vmail | sed -e "s/(.*$//; s/^.*=//"`
VMAIL_GID=`id vmail | sed -e "s/^.*gid=//; s/(.*$//"`

VMAIL_DIR="$RESPONSE"

echo "
VMAIL_UID=$VMAIL_UID
VMAIL_GID=$VMAIL_GID
VMAIL_DIR=$VMAIL_DIR
" > /root/vmail


echo "
virtual_alias_maps = mysql:/etc/postfix/mysql_virtual_alias_maps.cf
virtual_gid_maps = static:$VMAIL_GID
virtual_mailbox_base = $RESPONSE
virtual_mailbox_domains = mysql:/etc/postfix/mysql_virtual_domains_maps.cf
virtual_mailbox_maps = mysql:/etc/postfix/mysql_virtual_mailbox_maps.cf
virtual_mailbox_limit = 51200000
virtual_transport = virtual
virtual_uid_maps = static:$VMAIL_UID

" >> /etc/postfix/main.cf

exit 0
