#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

MYSQL_PASSWD=`grep MYSQL_PASSWD /root/passwd | awk -F= '{ print $2; }'`
POSTFIX_PASSWD=`grep POSTFIX_PASSWD /root/passwd | awk -F= '{ print $2; }'`

echo "
Installing $PROG_NAME
"

if [ -d /var/www/postfixadmin ] ; then
	rm -rf /var/www/postfixadmin
fi

if [ ! -d /var/www ] ; then
	mkdir /var/www
fi

echo -e '* \033[32mDownloading...\033[0m'
wget -q --directory-prefix=/usr/local/src/AdminInstall/src/. http://212.43.241.29/AdminInstall_Src/postfixadmin-2.1.0.tgz

POST_ADM_TGZ=`find $OAT_SRC -iname postfixadmin\*gz | awk -F/ '{ print $7; }'`

echo -e '* \033[32mDecompressing...\033[0m'
tar xzf $OAT_SRC/$POST_ADM_TGZ -C /var/www

echo -e '* \033[32Installing...\033[0m'
POST_ADM_REP=`find $OAT_SRC -iname postfixadmin\*gz | awk -F/ '{ print $7; }' | sed -e "s/\.tgz.*$//"`

mv /var/www/$POST_ADM_REP /var/www/postfixadmin

mv /var/www/postfixadmin/setup.php /var/www/postfixadmin/setup.php.old

POSTFIX_PASSWD=`grep POSTFIX_PASSWD /root/passwd | awk -F= '{print $2;}'`

cp /var/www/postfixadmin/config.inc.php.sample /var/www/postfixadmin/config.inc.php

mv /var/www/postfixadmin/config.inc.php /var/www/postfixadmin/config.inc.php.tmp
sed -e "s+database_user'] = 'postfixadmin';+database_user'] = 'postfix';+; s+database_password'] = 'postfixadmin';+database_password'] = '$POSTFIX_PASSWD';+; s+quota'] = 'NO';+quota'] = 'YES';+; s+encrypt'] = 'md5crypt';+encrypt'] = 'cleartext';+; s+aliases'] = '10';+aliases'] = '0';+; s+mailboxes'] = '10';+mailboxes'] = '0';+; s+maxquota'] = '10';+maxquota'] = '0';+; s+vacation'] = 'NO';+vacation'] = 'YES';+" < /var/www/postfixadmin/config.inc.php.tmp > /var/www/postfixadmin/config.inc.php
rm /var/www/postfixadmin/config.inc.php.tmp

echo -e '
* \033[32mDoing required actions to enable the vacation module...\033[0m
'

echo "vacation:*:65501:65501::0:0:Virtual Vacation:/nonexistent:/sbin/nologin" >>/etc/passwd
echo "vacation:*:65501:" >>/etc/group

/bin/mkdir /var/spool/vacation
/bin/chown vacation:vacation /var/spool/vacation

cp -f /var/www/postfixadmin/VIRTUAL_VACATION/vacation.pl /var/spool/vacation/.
cp -f /var/www/postfixadmin/VIRTUAL_VACATION/mail-filter /var/spool/vacation/.

/bin/chown vacation:vacation /var/spool/vacation/*

echo 'vacation  unix  -       n       n       -       -       pipe
  flags=Rq user=vacation argv=/var/spool/vacation/mail-filter -f ${sender} -- ${recipient}' >> /etc/postfix/master.cf


echo -e '
* \033[32mReloading Postfix\033[0m
'

/usr/sbin/postfix reload

echo -e '
* \033[32mCreating required MySQL databases and tables ...\033[0m
'
mysql -u root -p$MYSQL_PASSWD < $OAT_CONF/mysql/DATABASE_MYSQL.TXT

echo "POSTFIXADMIN = 1" >> /root/install_report

echo "
Installation of $PROG_NAME finished successfully.
"
exit 0
