#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh

CHECK_APACHE_VERSION=`dpkg -l |grep apache |grep common| grep "next generation" |awk '{print $2}' |cut -d'-' -f1 > /tmp/def_apache_version`
APACHE_VERSION=`cat /tmp/def_apache_version`

PROG_NAME="mod_jk"

echo "
Installing mod_jk
"
if [ "$APACHE_VERSION" = "apache2" ];then


echo -e '* \033[32mInstalling required packages...\033[0m
'

	apt-get install apache2-threaded-dev	
	apt-get install libtool automake autoconf

echo -e '* \033[32mDownloading mod_jk sources...\033[0m
'

	wget -q --directory-prefix=/usr/local/src/. http://212.43.241.29/AdminInstall_Src/jakarta-tomcat-connectors-jk-1.2.6-src.tar.gz

echo -e '* \033[32mCompiling...\033[0m
'

	tar xzf /usr/local/src/jakarta-tomcat-connectors-jk-1.2.6-src.tar.gz -C /usr/local/src
	cd /usr/local/src/jakarta-tomcat-connectors-jk-1.2.6-src/jk/native && ./buildconf.sh && ./configure --with-apxs=/usr/bin/apxs2 --with-java-home=/usr/local/java && make

echo -e '* \033[32mSetting up mod_jk...\033[0m
'

		if [ -f /usr/local/src/jakarta-tomcat-connectors-jk-1.2.6-src/jk/native/apache-2.0/mod_jk.so ];then
		
			cd /usr/local/src/jakarta-tomcat-connectors-jk-1.2.6-src/jk/native/apache-2.0 && cp mod_jk.so /usr/lib/apache2/modules/.
		
		fi
	#cd /usr/local/src/jakarta-tomcat-connectors-jk-1.2.6-src/jk/native/apache-2.0 && cp mod_jk.so /usr/lib/apache2/modules/.

	echo "LoadModule jk_module /usr/lib/apache2/modules/mod_jk.so" > /etc/apache2/mods-available/mod_jk.load

echo "
<IfModule !mod_jk.c>
  LoadModule jk_module /usr/lib/apache2/modules/mod_jk.so
</IfModule>

JkWorkersFile /usr/local/tomcat/conf/jk/workers.properties
JkLogFile /var/log/apache2/mod_jk.log

JkLogLevel info
" >> /etc/apache2/httpd.conf

	a2enmod mod_jk
	/etc/init.d/apache2 force-reload

	echo "
	"

	if [ -d /usr/local/tomcat/conf ];then

	mkdir /usr/local/tomcat/conf/auto
	mkdir /usr/local/tomcat/conf/jk

	touch /usr/local/tomcat/conf/auto/mod_jk.conf
	touch /usr/local/tomcat/conf/jk/workers.properties

	# Chargement du module si pas pass par a2enmod

	echo "
<IfModule !mod_jk.c>
  LoadModule jk_module /usr/lib/apache2/modules/mod_jk.so
</IfModule>

JkWorkersFile "/usr/local/tomcat/conf/jk/workers.properties"
JkLogFile "/usr/local/tomcat/logs/mod_jk.log"

JkLogLevel info
" > /usr/local/tomcat/conf/auto/mod_jk.conf

	# configuration du connector

	echo "
worker.list=ajp13
worker.ajp13.port=8009
worker.ajp13.host=localhost
worker.ajp13.type=ajp13
worker.ajp13.cachesize=10
worker.ajp13.cache_timeout=6000
worker.ajp13.socket_timeout=3000
" > /usr/local/tomcat/conf/jk/workers.properties

	fi

else

	apt-get install libapache-mod-jk
	rm /etc/libapache-mod-jk/workers.properties
		cp $OAT_CONF/modjk/workers.properties /etc/libapache-mod-jk/.
			mkdir -p /var/lib/tomcat/conf
		cp $OAT_CONF/modjk/mod_jk.conf /var/lib/tomcat/conf/.
	touch /var/log/apache/mod_jk.log

echo "
<IfModule mod_jk.c>

	JkWorkersFile /etc/libapache-mod-jk/workers.properties
	Include /var/lib/tomcat/conf/mod_jk.conf
	JkLogFile /var/log/apache/mod_jk.log

	# debug, info, error and emerg
	JkLogLevel info

	#					#
	#	Put your virtualhost here	#
	#					#

</IfModule>
" >> /etc/apache/httpd.conf

apachectl restart

fi

echo "MOD_JK = 1" >>/root/install_report

echo "
Installation of $PROG_NAME finished successfully.
"
exit 0
