#!/bin/sh

. $OAT_LIBS/libRESPONSE.sh
. $OAT_LIBS/libYESNO.sh

CHECK_APACHE_VERSION=`dpkg -l |grep apache |grep common| grep "next generation" |awk '{print $2}' |cut -d'-' -f1 > /tmp/def_apache_version`
APACHE_VERSION=`cat /tmp/def_apache_version`

echo "
Installing $PROG_NAME
"

apt-get install php4

if [ "$APACHE_VERSION" = "apache2" ];then

echo "
Apache version 2 detected. Installing required packages...
"

# installation du support PHP4 pour Apache 2

	apt-get install libapache2-mod-php4

fi

promptYESNO "Do you want to have cgi support into php4" "n"
  if [ "$YESNO" = "y" ] ; then
    apt-get install php4-cgi
	echo "PHP4_CGI = 1" >>/root/install_report	
  fi

promptYESNO "Do you want to have mysql support into php4" "n"
  if [ "$YESNO" = "y" ] ; then
    apt-get install php4-mysql
	echo "PHP4_MYSQL = 1" >>/root/install_report	
  fi

if [ "$APACHE_VERSION" = "apache2" ];then

# CASE APACHE2
mv /etc/apache2/apache2.conf /etc/apache2/apache2.conf.tmp
# Ajout addtype php
sed -e "s+#AddType application/x-httpd-php .php+AddType application/x-httpd-php .php+" < /etc/apache2/apache2.conf.tmp > /etc/apache2/apache2.conf

	# done, on supprime les fichiers tmp
	rm -f /etc/apache2/apache2.conf.tmp

	else

mv /etc/apache/httpd.conf /etc/apache/httpd.conf.tmp
sed -e "s+DirectoryIndex index.html index.htm index.shtml index.cgi+DirectoryIndex index.html index.htm index.shtml index.cgi index.php+; s+#AddType application/x-httpd-php .php+AddType application/x-httpd-php .php+" < /etc/apache/httpd.conf.tmp > /etc/apache/httpd.conf

#echo "LoadModule php4_module /usr/lib/apache/1.3/libphp4.so" >> /etc/apache/modules.conf

	# done, on supprime les fichiers tmp
	rm /etc/apache/httpd.conf.tmp

fi

promptYESNO "Do you want to have gd2 support into php4" "n"
  if [ "$YESNO" = "y" ] ; then
  	if [ -d /usr/lib/X11 ];then
		rm -r /usr/lib/X11
	fi

    apt-get install php4-gd
    	echo "PHP4_GD2 = 1" >>/root/install_report
  fi

promptYESNO "Do you want to have PEAR support into php4" "n"
  if [ "$YESNO" = "y" ] ; then
    apt-get install php4-pear
    	echo "PHP4_PEAR = 1" >>/root/install_report
  fi


if [ "$APACHE_VERSION" = "apache2" ];then

	/usr/sbin/a2enmod php4 >/dev/null
	/etc/init.d/apache2 force-reload

else

	/etc/init.d/apache restart

fi

echo "

Copying a phpinfo.php file to the right place (/var/www)
"
cp $OAT_CONF/php/phpinfo.php /var/www/.

echo "PHP4 = 1" >>/root/install_report

echo "
Installation of $PROG_NAME finished successfully.

"
exit 0
