/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import org.gjt.mm.mysql.MysqlDefs;

public class Field {
    int _length;
    String _name;
    String _tableName;
    int _sqlType = -1;
    int _mysqlType = -1;
    short _colFlag;
    int _colDecimals;
    private static final int _AUTO_INCREMENT_FLAG = 512;

    Field(String string, String string2, int n, int n2, short s, int n3) {
        this._tableName = new String(string);
        this._name = new String(string2);
        this._length = n;
        this._colFlag = s;
        this._colDecimals = n3;
        this._mysqlType = n2;
        this._sqlType = MysqlDefs.mysqlToJavaType(n2);
        boolean bl = this.isBinary();
        if (this._sqlType == -4 && !bl) {
            this._sqlType = -1;
        } else if (this._sqlType == -3 && !bl) {
            this._sqlType = 12;
        }
    }

    public Field(String string, String string2, int n, int n2) {
        this._tableName = new String(string);
        this._name = new String(string2);
        this._length = n2;
        this._sqlType = n;
        this._colFlag = 0;
        this._colDecimals = 0;
    }

    public String getTable() {
        if (this._tableName != null) {
            return this._tableName;
        }
        return null;
    }

    public String getName() {
        if (this._name != null) {
            return new String(this._name);
        }
        return null;
    }

    public String getFullName() {
        String string = this._tableName + "." + this._name;
        return string;
    }

    public String getTableName() {
        return this._tableName;
    }

    public int getLength() {
        return this._length;
    }

    public int getSQLType() {
        return this._sqlType;
    }

    public int getMysqlType() {
        return this._mysqlType;
    }

    int getDecimals() {
        return this._colDecimals;
    }

    boolean isNotNull() {
        return (this._colFlag & 1) > 0;
    }

    public boolean isPrimaryKey() {
        return (this._colFlag & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this._colFlag & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this._colFlag & 8) > 0;
    }

    public boolean isBlob() {
        return (this._colFlag & 0x10) > 0;
    }

    public boolean isUnsigned() {
        return (this._colFlag & 0x20) > 0;
    }

    public boolean isZeroFill() {
        return (this._colFlag & 0x40) > 0;
    }

    public boolean isBinary() {
        return (this._colFlag & 0x80) > 0;
    }

    public boolean isAutoIncrement() {
        return (this._colFlag & 0x200) > 0;
    }

    public String toString() {
        return this.getFullName();
    }
}

