<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Routines de gestion des filesystems
#

# Format des tableaux de fichiers :
#
# key   = path
# value = array
#	type = d | f | l
#	date = 'YYYY/MM/DD HH:MM:SS'
#	size = size
#

#
# rsync_ls($module_index, $path): Renvoie un tableau contenant la liste des fichiers du module concern
# en fonction du path prcis.
#

function rsync_ls($m, $p)
{
	global $rsync, $ssh, $ssh_cmd, $modules;

	$cmd =  escapeshellcmd($rsync) . ' ';
	$cmd .= '-e ' . $ssh_cmd . ' ';
	$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule'] . $p);

	$files = array();

	$fds = array(
		1 => array('pipe', 'w'),	# stdout
		2 => array('pipe', 'w'),	# stderr
	);

	$proc = proc_open($cmd, $fds, $pipes);

	$lines = array();

	if (!is_resource($proc)) { die("<br>proc_open() failed !<br>\n"); }

	$z = fopen('/tmp/debug.log', 'a+');

	while (!feof($pipes[1]))			# On lit stdout
	{
		$v = fgets($pipes[1], 2048);
		if (!$v) { continue; }
		$v = rtrim($v);					# On supprime le '\n' final
		if ($v != '') { $lines[] = $v; }
	}

	while (!feof($pipes[2]))			# On lit stderr
	{
		$v = fgets($pipes[2], 2048);
		if (!$v) { continue; }
		$v = rtrim($v);					# On supprime le '\n' final
		if ($v != '') { $lines[] = $v; }
	}

	fclose($pipes[1]);				# On ferme stdout
	fclose($pipes[2]);				# On ferme stderr

	$rv = proc_close($proc);		# On termine le processus

	# On vrifie que la 1ere ligne est bien un fichier. Sinon, c'est un message d'erreur.

	if (sizeof($lines) < 1 || !ereg('^[dlspcb-][rwxtSs-]{6}', $lines[0]))
	{
		if ($lines[0] == 'client: nothing to do: perhaps you need to specify some filenames or the --recursive option?')
			return FALSE;

		print "<b><font color=\"red\"><pre>\nUNEXPECTED RSYNC OUTPUT :\n";
		if (sizeof($lines)) { while (list(, $v) = each($lines)) print "$v\n"; }
		else print "(no output)\n";
		print "</pre></font></b>\n";
		return FALSE;
	}

	while (list(, $v) = each($lines))
	{
		$s = split(' +', $v, 5);

		if ($s[4] == '.') { continue; }

		$files[$s[4]] = array();

		if     ($s[0][0] == 'd')	{ $type = 'd'; }		# Directory
		else if ($s[0][0] == '-')	{ $type = 'f'; }		# File
		else if ($s[0][0] == 'l')	{ $type = 'l'; }		# Link
		else   							{ continue; }			# Type de fichier non support !

		$files[$s[4]]['type'] = $type;
		$files[$s[4]]['date'] = $s[2] . ' ' . $s[3];

		if ($type == 'f') $files[$s[4]]['size'] = $s[1];
	}

	return $files;
}

#
# local_ls($module_index, $path): Renvoie un tableau contenant la liste des fichiers locaux du module concern
# en fonction du path prcis.
#

function local_ls($m, $p)
{
	global $modules;

	$p = $modules[$m]['lpath'] . $p;

	$d = @opendir($p);

	if (!$d)
	{
		# Erreur lors de l'ouverture du rpertoire local (permission denied ou no such file)
		return FALSE;
	}

	$files = array();

	while ($e = readdir($d))
	{
		if ($e == '.' || $e == '..') { continue; }

		$files[$e] = array();

		$s = stat($p . '/' . $e);

		if (is_dir($p . '/' . $e))				{ $type = 'd'; }
		else if (is_file($p . '/' . $e))		{ $type = 'f'; }
		else if (is_link($p . '/' . $e))		{ $type = 'l'; }
		else											{ continue; }

		$files[$e]['type'] = $type;
		$files[$e]['date'] = strftime('%Y/%m/%d %H:%M:%S', $s[9]);

		if ($type == 'f') $files[$e]['size'] = $s[7];
	}

	closedir($d);

	ksort($files);

	return $files;
}

?>
