<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

# Displays possibles :
#
# - liste des modules
# - affichage d'un rpertoire d'un module
# - affichage de toutes les dsynchros d'un module
# - affichage des diffrences d'un fichier
#
# Paramtres en GET :
#
# l = path d'un fichier local    afficher
# r = path d'un fichier distant  afficher
# d = path d'un fichier sur lequel il faut faire un diff entre local et distant
# t = path d'un fichier distant  supprimer (trash)
# s : vaut '1' si on doit afficher toutes les dsynchros
# cl = copy d'un fichier local DE LA SOURCE vers la cible
# cr = copy d'un fichier distant DE LA CIBLE vers la source
#
# Les rewrites rules placent le 1er "rpertoire" apres $base_url dans $CC_MODULE et tout le path suivant
# dans '$CC_PATH'.
#

error_reporting(E_ALL);

# On s'assure que la configuration est clean.

if ((int) ini_get('magic_quotes_gpc') || (int) ini_get('magic_quotes_runtime')
	|| (int) ini_get('magic_quotes_sybase') || (int) ini_get('register_globals'))
{
	phpinfo();
	die("<tt>Les options PHP 'magic_quotes_*' et 'register_globals' doivent tre dsactives !!</tt>");
}

#

require('./config.inc');
require('./tools.inc');

#

if (!getenv('CC_MODULE'))
{
	# Pas de module prcis : on affiche la liste des modules disponibles
	require('./show_modules.inc');
}

# Recherche du module spcifi

$m = -1;	# $m contiendra l'index du module concern dans le tableau $modules

while (list($k, $v) = each($modules)) { if ($v['name'] == getenv('CC_MODULE')) { $m = $k; break; } }

if ($m == -1) { die("Module <tt><b>" . getenv('CC_MODULE') . "</b></tt> inconnu !"); }

$ssh_cmd = escapeshellarg($ssh . ' -l ' . $modules[$m]['sshuser'] . ' -i ' . $modules[$m]['sshkey']);

# Examen de la fonction a raliser

if (isset($_GET['cl']) || isset($_GET['cr']))
{
	# On doit transferer un fichier/rpertoire par rsync.
	require('./transfer.inc');
}

if (isset($_GET['d']))
{
	# On doit afficher les diffrences entre un fichier local et un fichier distant.
	require('./show_diff.inc');
}

if (isset($_GET['t']))
{
	# On doit supprimer un fichier distant.
	require('./remote_delete.inc');
}

if (isset($_GET['l']))
{
	# On doit afficher le contenu d'un fichier local.
	require('./show_file.inc');
}

if (isset($_GET['r']))
{
	# On doit afficher le contenu d'un fichier distant.
	require('./show_file.inc');
}

if (isset($_GET['s']) && $_GET['s'] == '1')
{
	# On doit rcapituler toutes les dsynchros sur le module.
	require('./show_summary.inc');
}

# Sinon, par dfaut, on affiche le contenu du module, par rpertoire.

require('./show_folder.inc');

?>
