<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Affiche les diffrences entre un fichier local et un fichier distant.
#

#
# Le concept est de rappatrier le fichier distant grce  rsync dans un rpertoire temporaire,
# et d'executer un diff entre les 2 fichiers.
# Ensuite, suppression du rpertoire temporaire.
#

$url = $base_url . urlencode($modules[$m]['name']);	# Variable contenant l'URL

$path = $_GET['d'];

$p_parts = explode_path($path);

if ($p_parts === FALSE) { Header('Location: ' . $url . '/'); exit(); }

$file = end($p_parts);

$url .= url_path_parent($p_parts);

# Ok.

# Cration du rpertoire temporaire.

$p = '/tmp/' . random_name();

mkdir($p);

# On importe le fichier distant dans le rpertoire.

$cmd =  escapeshellcmd($rsync) . ' ';
$cmd .= '-prlt ';
$cmd .= '-e ' . $ssh_cmd . ' ';
$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule'] . $path) . ' ';
$cmd .= escapeshellarg($p) . ' ';
$cmd .= '2>&1';

$r = exec($cmd, $f);

if (sizeof($f))
{
	rmdir($p);

	print "<html><head>\n<title>Probleme lors du transfert !</title>\n";
	print "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_url . "css.php\">\n";
	print "</head><body>\n";
	print "<b><font color=\"red\"><pre>\nUNEXPECTED RSYNC OUTPUT :\n";
	if (sizeof($f)) { while (list(, $v) = each($f)) print "$v\n"; }
	else print "(no output)\n";
	print "</pre></font></b>\n";
	print "<br><br><a href=\"$url\">Retour</a>\n";
	exit();
}

# On execute la command 'diff' entre les 2 fichiers.

$cmd = escapeshellcmd($diff) . ' -uN -U 5 ';
$cmd .= escapeshellarg($p . '/' . $file) . ' ';
$cmd .= escapeshellarg($modules[$m]['lpath'] . $path) . ' ';
$cmd .= '2>&1';

$r = exec($cmd, $f);

# Les 2 premires lignes de la sortie du diff (si elles sont prsentes)
# indiquent les 2 fichiers qui ont t compares. On remplace ces 2 lignes par
# des lignes  nous, afin de masquer les paths utiliss sur le filesystem, et
# pour donner plus de renseignements (nom du module, nom des machines, date et
# tailles des fichiers compars)

$ln = $modules[$m]['name'] . '@' . $modules[$m]['rname'] . ': ';
$rn = $modules[$m]['name'] . '@' . $modules[$m]['lname'] . ': ';

$l = max(strlen($ln), strlen($rn));

$ln = $ln . str_repeat(' ', $l - strlen($ln));
$rn = $rn . str_repeat(' ', $l - strlen($rn));

$s = stat($p . '/' . $file);
$d0 = strftime('%Y/%m/%d %H:%M:%S', $s[9]);
$d0 .= sprintf(' (taille = %d)', $s[7]);
$l0 = '--- ' . $ln . $path . " $d0";

$s = stat($modules[$m]['lpath'] . $path);
$d1 = strftime('%Y/%m/%d %H:%M:%S', $s[9]);
$d1 .= sprintf(' (taille = %d)', $s[7]);
$l1 = '+++ ' . $rn . $path . " $d1";

# On affiche la sortie du diff, en coloriant les lignes pour plus de visibilit.

$c = 0;

print "<pre>";

if (!sizeof($f))
{
	if ($d0 != $d1)	$f = array('', '', '', " Seule la date des fichiers diffre, le contenu est identique.");
	else					$f = array('', '', '', " Aucune diffrence. Les fichiers sont identiques.");
}
else if (sizeof($f) == 1 && substr($f[0], 0, 13) == 'Binary files ')
{
	$f = array('', '', '', " Fichiers binaires DIFFERENTS.");
}

for ($v = reset($f), $c = 0; $v !== FALSE; $v = next($f), $c++)
{
	if ($c == 0)		$v = $l0;
	else if ($c == 1) $v = $l1;

	if (substr($v, 0, 1) == '-')			{ $c1 = '<font color="red"><b>'; $c2 = '</b></font>'; }
	else if (substr($v, 0, 1) == '+')	{ $c1 = '<font color="blue"><b>'; $c2 = '</b></font>'; }
	else if (substr($v, 0, 2) == '@@')	{ $c1 = '<font color="green"><b>'; $c2 = '</b></font>'; }
	else											{ $c1 = $c2 = ''; }

	print $c1 . htmlentities($v) . $c2 . "\n";
}

print "</pre>\n";

unlink($p . '/' . $file);
rmdir($p);

exit();

?>
