<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Affiche le contenu d'un fichier local ou distant.
#

if (isset($_GET['l']))			{ $path = $_GET['l']; $mode= 'l'; }
else if (isset($_GET['r']))	{ $path = $_GET['r']; $mode = 'r'; }
else die();

$p_parts = explode_path($path);

if ($p_parts === FALSE) { Header('Location: ' . $url); exit(); }

$file = end($p_parts);

if ($mode == 'l')
{
	$f = $modules[$m]['lpath'] . $path;
}
else if ($mode == 'r')
{
	# Le fichier est sur la machine distante.

	# Cration du rpertoire temporaire.

	$tmp_dir = '/tmp/' . random_name();

	mkdir($tmp_dir);

	# On importe le fichier distant dans le rpertoire.

	$cmd =  escapeshellcmd($rsync) . ' ';
	$cmd .= '-prlt ';
	$cmd .= '-e ' . $ssh_cmd . ' ';
	$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule'] . $path) . ' ';
	$cmd .= escapeshellarg($tmp_dir) . ' ';
	$cmd .= '2>&1';

	$r = exec($cmd, $f);

	if (sizeof($f))
	{
		rmdir($tmp_dir);

		print "<html><head>\n<title>Probleme lors du transfert !</title>\n";
		print "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_url . "css.php\">\n";
		print "</head><body>\n";
		print "<b><font color=\"red\"><pre>\nUNEXPECTED RSYNC OUTPUT :\n";
		if (sizeof($f)) { while (list(, $v) = each($f)) print "$v\n"; }
		else print "(no output)\n";
		print "</pre></font></b>\n";
		print "<br><br><a href=\"$url\">Retour</a>\n";
		exit();
	}

	$f = $tmp_dir . '/' . $file;
}
else die();

if (ereg('\.(php|php3|php4|php5|inc)$', $file))
{
	# Si le fichier possde une extension .php, .php3 ou .inc, on l'affiche avec
	# la coloration syntaxique de PHP.

	print "<pre>";
	show_source($f);
	print "</pre>";
}
else
{
	# Si le fichier est une image, on met les donnes en raw avec un mime type adapt.
	# Sinon, on emet le fichier tel quel.

	$raw = TRUE;

	if			(ereg('\.gif$', $file))					{ Header('Content-type: image/gif');  }
	else if	(ereg('\.(jpg|jpeg|jpe)$', $file))	{ Header('Content-type: image/jpeg'); }
	else if	(ereg('\.(png)$', $file))				{ Header('Content-type: image/png');  }
	else		{ $raw = FALSE; print "<pre>\n"; }

	$fd = fopen($f, 'r');

	while (!feof($fd))
	{
		$r = fread($fd, 2048);
		print ($raw)? $r : htmlentities($r);
	}

	fclose($fd);
}

if ($mode == 'r')
{
	# On supprime le fichier et le rpertoire temporaires.
	unlink($f);
	rmdir($tmp_dir);
}

exit();

?>
