<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Affiche les fichiers d'un rpertoire d'un module, en deux parties : tels qu'ils sont sur la machine locale,
# et tels qu'ils sont sur la machine cible.
#

require('./fsutils.inc');

#
# Actions possibles :
#
# Copy item from source to target						=> clic sur l'icone '=>'
# Copy item from target to source						=> clic sur l'icone '<='
# Delete item in target										=> clic sur l'icone 'x'
# Show diff of an item between source and target	=> clic sur l'icone 'D'
#
# Show all desynchros										=> clic sur un icne en haut  droite ?
#

$url = $base_url . urlencode($modules[$m]['name']);

if (getenv('CC_PATH'))	$path = '/' . getenv('CC_PATH');	# On prend le PATH  afficher
else							$path = '/';							# On affiche la rachine du module

$p_parts = explode_path($path, TRUE);

if ($p_parts === FALSE) { Header('Location: ' . $url . '/'); exit(); }

# On rcupre la liste des fichiers.

$llist = local_ls($m, $path);
$rlist = rsync_ls($m, $path);

$lfound = is_array($llist);	# TRUE si on a bien pu rcuprer la liste des fichiers locaux,   FALSE sinon.
$rfound = is_array($rlist);	# TRUE si on a bien pu rcuprer la liste des fichiers distants, FALSE sinon.

# Ok, on peut gnerer le code HTML.

print "<html><head>\n<title>Synchronisation " . htmlentities($modules[$m]['comment']) . "</title>\n";
print "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_url . "css.php\">\n";
print "</head><body>\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
print "<tr><td class=\"headers\" colspan=\"3\">\n";
print "<table border=\"0\# cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td>\n";
print "<a href=\"" . $base_url . "\">Module</a> " . htmlentities($modules[$m]['comment']);
print "\n</td><td align=\"right\">\n";
print "<a target=\"blank\" href=\"$url/?s=1\"><b>R&eacute;sum&eacute;</b></a>\n";
print "\n</td></tr></table>\n";
print "\n</td></tr>\n";
print "<tr><td class=\"path\" colspan=\"3\">";

# Construction du path clickable.

print "<tt><b>&nbsp;<a href=\"$url/\">" . htmlentities($modules[$m]['name']) . " ::</a>&nbsp;/&nbsp;";

$c = '/';

for ($v = reset($p_parts); $v; $v = next($p_parts))
{
	$c .= urlencode($v) . '/';
	print '<a href="' . $url . $c . '">' . htmlentities($v) . '</a>&nbsp;/&nbsp;';
}

print "</b></tt></td></tr>\n";

#

$lmissing = '<img src="' . $base_url . 'blank.png"><font color="#AAAAAA"><i>&eacute;l&eacute;ment absent localement</i></font>';
$rmissing = '<img src="' . $base_url . 'blank.png"><font color="#AAAAAA"><i>&eacute;l&eacute;ment absent sur la cible</i></font>';
$unknown  = '<center><font color="red"><b><i>R&eacute;pertoire demand&eacute; inexistant ou inaccessible</i></b></font></center>';
$nothing  = "<center><i>aucun &eacute;l&eacute;ment dans ce r&eacute;pertoire</i></center>";

$images = array('f' => '<img border="0" src="' . $base_url . 'file.png">', 'd' => '<img border="0" src="' . $base_url . 'folder.png">');

print "<tr>\n";
print "<th class=\"headers\" width=\"50%\">Fichiers locaux ("   . htmlentities($modules[$m]['lname']) . ")</th>\n";
print "<th class=\"headers\">&nbsp;</td>\n";
print "<th class=\"headers\" width=\"50%\">Fichiers distants (" . htmlentities($modules[$m]['rname']) . ")</th>\n";
print "</tr>\n";

# $lfound, $rfound : TRUE si OK, FALSE si probleme d'access au rpertoire.
# $l, $r : lements des tableaux de fichier, ou FALSE si problme d'accs au rpertoire.
# $la, $ra : message d'alerte si rpertoire inacessible, puis '' pour ne pas rpeter plusieurs fois l'alerte.
# $lk, $rk : key (== nom du fichier) courant
# $ln, $rn : code HTML de la ligne  afficher.

if ($lfound) { $l = reset($llist); } else { $l = FALSE; $la = $unknown; }
if ($rfound) { $r = reset($rlist); } else { $r = FALSE; $ra = $unknown; }

$loop = 0;	# Compteur bidouillesque pour empecher une boucle sans fin

$row = 'row_a';

do
{
	if ($lfound) { $lk = key($llist); } else { $lk = False; }
	if ($rfound) { $rk = key($rlist); } else { $rk = False; }

	if (is_null($lk)) { $lk = False; }
	if (is_null($rk)) { $rk = False; }

	if (	($lk !== $rk) || ($l['type'] != $r['type']) ||
			($l['type'] != 'd' && $l['date'] != $r['date']))
	{
		$b1 = '<b>';
		$b2 = '</b>';
	}
	else { $b1 = $b2 = ''; }

	$action = '&nbsp;'; $a1 = $a2 = $a3 = $a4 = '';

	# Examen de la partie source

	if (!$lfound) { $ln = $la; $la = ''; }
	else if ($lk !== False && ($rk === False || strcmp($lk, $rk) <= 0))
	{
		$i = (isset($images[$l['type']]))? $images[$l['type']] : '';

		$ex = exclude($path . $lk);

		if ($ex)
		{
			$n1 = '<font color="#AAAAAA">';
			$n2 = '</font>';
			$b1 = $b2 = '';
		}
		else if ($l['type'] == 'd')
		{
			$n1 = '<a href="' . $url . $path . $lk . '/">';
			$n2 = '</a>';
		}
		else if ($l['type'] == 'f')
		{
			$n1 = '<a target="blank" href="' . $url . '/?l=' . urlencode($path . $lk) . '">';
			$n2 = '</a>';
		}
		else { $n1 = $n2 = ''; }

		$ln = $n1 . $i . '<tt>' . $b1 . htmlentities($lk) . $b2 . '</tt>' . $n2;

		if ($b1 && $rfound && ($l['type'] != 'd' || $rk === False || strcmp($lk, $rk) < 0))
		{
			# Icne pour transferer le fichier de la source vers la cible
			$a2  = '<a href="' . $url . '/?cl=' . urlencode($path . $lk) . '">';
			$a2 .= '<img border="0" src="' . $base_url . 'rarrow.png" title="';
			$a2 .= "Transferer '" . htmlentities($lk) . "' de " . htmlentities($modules[$m]['lname']);
			$a2 .= " vers " . htmlentities($modules[$m]['rname']) ."\">";
			$a2 .= '</a>';
		}
	}
	else if ($rk === False) { $ln = $nothing; }
	else { $ln = $lmissing; }

	# Examen de la partie cible

	if (!$rfound) { $rn = $ra; $ra = ''; }
	else if ($rk !== False && ($lk === False || strcmp($lk, $rk) >= 0))
	{
		$i = (isset($images[$r['type']]))? $images[$r['type']] : '';

		$ex = exclude($path . $rk);

		if ($ex)
		{
			$n1 = '<font color="#AAAAAA">';
			$n2 = '</font>';
			$b1 = $b2 = '';
		}
		else if ($r['type'] == 'd')
		{
			$n1 = '<a href="' . $url . $path . $rk . '/">';
			$n2 = '</a>';
		}
		else if ($r['type'] == 'f')
		{
			$n1 = '<a target="blank" href="' . $url . '/?r=' . urlencode($path . $rk) . '">';
			$n2 = '</a>';
		}
		else { $n1 = $n2 = ''; }

		$rn = $n1 . $i . '<tt>' . $b1 . htmlentities($rk) . $b2 . '</tt>' . $n2;

		if ($rk !== $lk && !$ex)
		{
			# Icne pour supprimer le fichier sur la cible
			$a4  = '<a href="' . $url . '/?t=' . urlencode($path . $rk) . '">';
			$a4 .= '<img border="0" src="' . $base_url . 'delete.png" title="';
			$a4 .= "Supprimer '" . htmlentities($rk) . "' sur " . htmlentities($modules[$m]['rname']);
			$a4 .= '"></a>';
		}

		if ($b1 && $lfound && ($r['type'] != 'd' || $lk === False || strcmp($rk, $lk) < 0))
		{
			# Icne pour transfrer le fichier de la cible vers la source
			$a1  = '<a href="' . $url . '/?cr=' . urlencode($path . $rk) . '">';
			$a1 .= '<img border="0" src="' . $base_url . 'larrow.png" title="';
			$a1 .= "Transferer '" . htmlentities($rk) . "' de " . htmlentities($modules[$m]['rname']);
			$a1 .= " vers " . htmlentities($modules[$m]['lname']) ."\">";
			$a1 .= '</a>';
		}
	}
	else if ($lk === False) { $rn = $nothing; }
	else { $rn = $rmissing; }

	# Gnration de la case d'icnes

	if ($a1 && $a2)
	{
		$a3  = '<a target="blank" href="' . $url . '/?d=' . urlencode($path . $lk) . '">';
		$a3 .= '<img border="0" src="' . $base_url . 'diff.png" title="';
		$a3 .= "Diff&eacute;rences pour '" . htmlentities($rk) . "' entre " . htmlentities($modules[$m]['rname']);
		$a3 .= " et " . htmlentities($modules[$m]['lname']) ."\">";
		$a3 .= '</a>';
	}

	$action .= ($a1)? $a1 : '<img src="' . $base_url . 'blank.png">';
	$action .= ($a2)? $a2 : '<img src="' . $base_url . 'blank.png">';
	$action .= ($a3)? $a3 : '<img src="' . $base_url . 'blank.png">';
	$action .= ($a4)? $a4 : '<img src="' . $base_url . 'blank.png">';

	# Affichage de la ligne du tableau

	print "<tr><td nowrap class=\"$row\">\n";
	print $ln . "\n";
	print "</td><td nowrap class=\"$row\">\n";
	print $action . "&nbsp;&nbsp;&nbsp;";
	print "</td><td nowrap class=\"$row\">\n";
	print $rn . "\n";
	print "</td></tr>\n";
	# On passe aux lments suivants s'ils sont disponibles

	if ($rk === False)					{ if ($lfound) { $l = next($llist); } }
	else if ($lk === False)				{ if ($rfound) { $r = next($rlist); } }
	else if (strcmp($lk, $rk) == 0)	{ if ($lfound) { $l = next($llist); } if ($rfound) { $r = next($rlist); } }
	else if (strcmp($lk, $rk) < 0)	{ if ($lfound) { $l = next($llist); } }
	else if (strcmp($lk, $rk) > 0)	{ if ($rfound) { $r = next($rlist); } }

	$row = ($row == 'row_a')? 'row_b' : 'row_a';

} while ($loop++ < 1024 && ($l || $r));

print "<tr><td class=\"end_table\" colspan=\"3\">&nbsp;</td></tr>\n";

print "</table>\n";

if ($loop >= 1024) { print '<font color="red"><b>Boucle sans fin dctecte !</b></font>'; }

print "</body></html>\n";

?>
