<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Affiche toutes les desynchros entre le module local et le module distant.
#

# XXX Pourquoi quand un fichier se trouve sur la cible mais pas sur la source,
# il n'apparait pas dans la liste ?

$cmd =  escapeshellcmd($rsync) . ' ';
$cmd .= '-nprlt --delete ';
$cmd .= '-e ' . $ssh_cmd . ' ';

for ($v = reset($modules[$m]['exclude']); $v; $v = next($modules[$m]['exclude']))
{
	$cmd .= '--exclude ' . escapeshellarg($v) . ' ';
}

$cmd .= escapeshellarg($modules[$m]['lpath'] . '/') . ' ';
$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule']);

$fds = array(
   0 => array('pipe', 'r'),	# stdin
   1 => array('pipe', 'w'),	# stdout
   2 => array('pipe', 'w'),	# stderr
);

print "<b>Liste des fichiers / rpertoires considrs comme dsynchroniss par rsync</b><br>\n";

print "<font size=\"-6\"><pre>\n";

$proc = proc_open($cmd, $fds, $pipes);

if (!is_resource($proc)) { die("<br>proc_open() failed !<br>\n"); }

$dn = '(none)';

while (!feof($pipes[1]))			# On lit stdout
{
	$v = fgets($pipes[1], 2048);
	$v = rtrim($v);					# On supprime le '\n' final
 	if ($v == 'building file list ... done') { continue; }
 	if (ereg('^wrote +[0-9]+ +bytes +read +[0-9]+ +bytes +[0-9.]+ bytes/sec$', $v)) { continue; }
 	if (ereg('^total size is [0-9]+ +speedup is +[0-9.]+$', $v)) { continue; }

	if ($v == '') continue;

	$d = dirname($v);

	if ($d == $dn)
	{
		$l = strlen($d) + 1;
		$v = str_repeat(' ', $l) . substr($v, $l);
	}
	else
		$dn = $d;

	print htmlentities($v) . "\n";
}

while (!feof($pipes[2]))			# On lit stderr - normalement il n'y a rien.
{
	$v = fgets($pipes[2], 2048);
	if ($v == '') break;
	print "#stderr: " . htmlentities($v) . "\n";
}

fclose($pipes[0]);				# On ferme stdin
fclose($pipes[1]);				# On ferme stdout
fclose($pipes[2]);				# On ferme stderr

$rv = proc_close($proc);		# On termine le processus

print "</pre></font>\n";

exit();

?>
