<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Routines diverses utilises un peu partout.
#

function explode_path($path, $must_end_with_slash = FALSE)
{
	# Cette fonction examine $path pour vrifier qu'il n'y a pas de parties illgales (par exemple '..')
	# On oblige le path a commencer par '/'. On l'oblige aussi a se terminer par '/' si le second argument
	# est TRUE.
	# Cette fonction renvoie un tableau avec chaque partie du path ou FALSE si le path est illgal.

	if (substr($path, 0, 1) != '/')
	{
		# Le path ne commence pas par un '/' => tentative de hack ?
		return FALSE;
	}

	if ($must_end_with_slash && substr($path, -1, 1) != '/')
	{
		# Le path ne se termine pas par un '/' => tentative de hack ?
		return FALSE;
	}

	$p_parts = split('/', substr($path, 1));

	for ($v = reset($p_parts); $v; $v = next($p_parts))
	{
		if ($v == '..' || $v == '.')
		{
			# Le path contient un '.' ou '..' => tentative de hack ?
			return FALSE;
		}
	}

	return $p_parts;
}


function path_parent($p_parts)
{
	# Cette fonction prend en argument un tableau tel que renvoy par la fonction explode_path(),
	# et reconstruit le path correspondant en omettant le dernier lement.

	$p = '/';
	for ($i = 0; $i < sizeof($p_parts) - 1; $i++) $p .= $p_parts[$i] . '/';
	return $p;
}


function url_path_parent($p_parts)
{
	# Cette fonction prend en argument un tableau tel que renvoy par la fonction explode_path(),
	# et construit un chaine du type '/path/' dstine  tre intgre dans une URL.
	# Le dernier lement du PATH est supprim de la chane.

	$p = '/';
	for ($i = 0; $i < sizeof($p_parts) - 1; $i++) $p .= urlencode($p_parts[$i]) . '/';
	return $p;
}


function exclude($path)
{
	# Cette fonction renvoie TRUE si on doit ignore $path pour le module courant, FALSE sinon.

	global $modules, $m;

	if (substr($path, -1) == '/')
	{
		$path = substr($path, 0, -1);
	}

	return in_array($path, $modules[$m]['exclude']);
}


function random_name()
{
	# Cette fonction renvoie un nom de fichier alatoire de 16  32 caractres.

	$chars = "azertyuiopmlkjhgfdsqwxcvbn9638527410NBVCXWQSDFGHJKLMPOIUYTREZA.-_";

	$l = mt_rand (16, 32);

	$n = '';

	for ($i = 0; $i < $l; $i++)
	{
		$n .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
	}

	return $n;
}


?>
