<?

# Interface PHP de synchronisation - Yann GROSSEL, 2003.11.04

#
# Transfert de fichier/rpertoire par rsync
#

$url = $base_url . urlencode($modules[$m]['name']);	# Variable contenant l'URL

if (isset($_GET['cl']))			{ $path = $_GET['cl']; $mode = 'l'; }
else if (isset($_GET['cr']))	{ $path = $_GET['cr']; $mode = 'r'; }
else die();

$p_parts = explode_path($path);

if ($p_parts === FALSE) { Header('Location: ' . $url . '/'); exit(); }

$url .= url_path_parent($p_parts);

$parent = substr(path_parent($p_parts), 0, -1);

# Okay, on tente le transfert.

if ($mode == 'l')
{
	# Export d'un fichier local.

	$cmd =  escapeshellcmd($rsync) . ' ';
	$cmd .= '-prlt ';
	$cmd .= '-e ' . $ssh_cmd . ' ';
	$cmd .= escapeshellarg($modules[$m]['lpath'] . $path) . ' ';
	$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule'] . $parent) . ' ';
	$cmd .= '2>&1';
}
else if ($mode == 'r')
{
	# Import d'un fichier distant.

	$cmd =  escapeshellarg($rsync) . ' ';
	$cmd .= '-prlt ';
	$cmd .= '-e ' . $ssh_cmd . ' ';
	$cmd .= escapeshellarg($modules[$m]['rmachine'] . '::' . $modules[$m]['rmodule'] . $path) . ' ';
	$cmd .= escapeshellarg($modules[$m]['lpath'] . $parent) . ' ';
	$cmd .= '2>&1';
}
else die();

# On execute la commande

$r = exec($cmd, $f);

if (!sizeof($f)) { Header('Location: ' . $url); exit(); }	# Aucune erreur lors du transfert

# Rsync a renvoy des messages : un problme est survenu. On l'affiche.

print "<html><head>\n<title>Probleme lors du transfert !</title>\n";
print "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_url . "css.php\">\n";
print "</head><body>\n";
print "<b><font color=\"red\"><pre>\nUNEXPECTED RSYNC OUTPUT :\n";
if (sizeof($f)) { while (list(, $v) = each($f)) print "$v\n"; }
else print "(no output)\n";
print "</pre></font></b>\n";
print "<br><br><a href=\"$url\">Retour</a>\n";

exit();

?>
