#! /bin/bash -e

if [ $# != 2 ]
then
        echo "Usage: $0 <hostname> <ip address>"
        exit 1
fi

base=~clarabck

umask 077
mkdir -p ${base}/Hosts/$1
cd       ${base}/Hosts/$1

chown clarabck:clarabck .

cat > rsyncd.conf << @EOF

log file = ${base}/Hosts/$1/rsync.log

[backups]
        path = ${base}/Hosts/$1/Files
        comment = Backups Config $1
        use chroot = false
        read only = false
        transfer logging = true
        hosts allow = $2/32
        hosts deny = 0.0.0.0/0

@EOF

mkdir Files

chown clarabck:clarabck *

echo "# REMPLACER CETTE LIGNE PAR LA CLE PUBLIQUE DE $1..." >> ${base}/.ssh/authorized_keys

vim ${base}/.ssh/authorized_keys +

