#! /usr/bin/perl -w
#
#	backups.pl	- 2003.11.28 Yann GROSSEL
#
#	Ce script doit tre plac sur les machines o il faut backuper les configs vers Vosges.
#

my $opts   = ' --progress -v';
my $ssh    = '/usr/bin/ssh -F /usr/local/Claranet/Configs-Backups/ssh.config';
my $conf   = '/usr/local/Claranet/Configs-Backups/backups.conf';
my $target = "212.43.241.12::backups";

my %items;
my @args;
my @excludes;
my $rsync;

my ($d, $m, $y) =  ((localtime())[3, 4, 5]);

open F, $conf or die "Can't open $conf $!";

while (<F>)
{
        my @parts;
        my $path = '/';

        chomp;

        if (m/^- /) { s!^- !!; push @excludes, "--exclude=$_"; next; }
        if (m/^\s*rsync\s*=\s*(\S+)/) { $rsync = $1; next; }

        next if ! m!^/!;

        s!^/!!;

        @parts = split m!/!;

        while (($p = shift @parts)) {
                $path .= $p;
                if (-d $path) { $path .= '/'; $items{$path} = 1; }
                else { $items{$path} = 1; next; }
                if (!scalar(@parts)) { $items{$path . '**'} = 1; }
        }
}

close F;

die "rsync not defined in '$conf' !" if (not defined($rsync));

push @args, $rsync, "-a", "--delete", "-b", "--backup-dir=Old-Versions";
push @args, "--suffix=" . sprintf(".%.4d-%.2d-%.2d", $y + 1900, $m + 1, $d);
push @args, "-v", "--progress" if (-t STDOUT);
push @args, "-e", $ssh;
push @args, @excludes;

delete $items{'/'};

for my $i (sort keys %items) { push @args, "--include=$i"; }

push @args, "--exclude=*", "/", $target;

exec @args;

