#! /usr/bin/perl -w

use Cwd;

my $old_cwd = getcwd();

$t = '/usr/local/Claranet/Configs-Backups';

if (`uname -n` eq "yg.noc.fr.clara.net\n") {
	$t = '/home/yg/Projects/Configs-Backups/TEST';
} elsif (`uname -n` eq "spike\n") {
	$t = '/home/yg/Projects/Claranet/Local/Configs-Backups/TEST';
}

##########################################################################################

sub find_command(@)
{
	for my $c (@_) { return $c if (-x $c); }
	return undef;
}

# die "\nCe script doit tre lanc en root !\n\n" if $>;
die "\nUtilisation: setup-client.pl <hostname du client>\n\n" if (scalar(@ARGV) != 1);

system("clear");

$host = $ARGV[0];
$host =~ tr/A-Z/a-z/;
$uhost =  substr($host, 0, 1);
$uhost =~ tr/a-z/A-Z/;
$uhost .= substr($host, 1);

$t =~ s/\/*$//;

umask 077;

system("mkdir -p $t");

chdir($t) or die "$!";

chmod 0700, '.';

# ssh.config

if (! -f 'ssh.config')
{
	open F, ">ssh.config" or die "$!";
	print F "\nHost 212.43.194.74\n\tUser clarabck\n\tIdentityFile $t/backups.key\n\n";
	close F or die "$!";
	chmod 0400, 'ssh.config';
}

# cls publique/prive

if (! -f 'backups.key' or ! -f 'backups.key.pub')
{
	system("ssh-keygen -t dsa -f backups.key -C 'Backups depuis $uhost' -N ''");
	chmod 0400, 'backups.key';
	chmod 0400, 'backups.key.pub';
	$new = "(NOUVELLE CLE, GENEREE IL Y A 2 SECONDES !)";
}
else
{
	$new = "(cl dj existante, non regnre)";
}

print "\n\nCl publique  copier-coller sur Tardenois $new :\n\n";

open F, 'backups.key.pub' or die "$!";
print 'command="exec /usr/bin/rsync --server --daemon --config ~clarabck/Hosts/' . $host . '/rsyncd.conf ." ';
while (<F>) { print; }
close F;

print "\n\n";

# backups.pl

unlink './backups.pl';

$cmd = find_command( '/usr/bin/wget', '/usr/local/bin/wget', '/usr/bin/fetch');
die "\n\nImpossible de trouver wget ou fetch :(\n\nAbort !\n\n" if (not defined $cmd);

system("$cmd http://svn.fr.clara.net/files/Configs-Backups/backups.pl");

chmod 0700, 'backups.pl';

# Crontab

$found = 0;

open F, '/etc/crontab' or die "$!";
while (<F>) { if (m/Configs-Backups.backups.pl/) { $found = 1; last; } }
close F;

if ($found) { print "\nNot updating crontab.\n\n"; }
else
{
	open F, '>>/etc/crontab' or die "$!";
	print F "\n# Backups automatiques des Configs\n";
	print F "# 3  22   *   *   *  root  /usr/local/Claranet/Configs-Backups/backups.pl\n\n";
	close F;
	print "\nCrontab UPDATEE - Mais il faut dcommenter la ligne ;)\n\n";
}

# backups.conf

if (! -f 'backups.conf')
{
	open F, '>backups.conf';

	print F "#\n";
	print F "# Configuration pour les fichiers/rpertoires de $uhost  backuper sur les serveurs de backups.\n";
	print F "#\n";
	print F "# Les lignes commen\xe7ant par '!' indiquent les fichiers/rpertoires  NE PAS backuper.\n";
	print F "# Les lignes commen\xe7ant par '/' indiquent les fichiers/rpertoires  backuper AVEC versionning.\n";
	print F "# Les lignes commen\xe7ant par '=' indiquent les fichiers/rpertoires  backuper SANS versionning.\n";
	print F "#\n";
	print F "# La ligne contenant 'rsync = '   indique le path de la commande rsync  utiliser.\n";
	print F "# La ligne contenant 'ssh = '     indique le path de la commande ssh  utiliser.\n";
	print F "# La ligne contenant 'targets = ' indique les machines cibles sur lesquelles faire les backups. Les diffrentes\n";
	print F "#                                 cibles (s'il y en a plusieurs) doivent \xeatre spares par des espaces. Les cibles\n";
	print F "#                                 sont au format: adresse_ip::module\n";
	print F "#\n\n";

	$ssh = find_command('/usr/local/bin/ssh', '/usr/bin/ssh');
	if (defined($ssh)) { print F "ssh = $ssh\n\n"; }
	else { print F "# ssh = ???\n\n"; print "\n\n===> ATTENTION: SSH NOT FOUND !\n\n"; }

	$rsync = find_command(
		'/usr/local/rsync-2.6.0/bin/rsync',
		'/usr/local/rsync-2.5.7/bin/rsync',
		'/usr/local/rsync-2.5.6/bin/rsync',
		'/usr/local/rsync/bin/rsync',
		'/usr/local/bin/rsync',
		'/usr/bin/rsync'
	);

	if (defined($rsync)) { print F "rsync = $rsync\n\n"; }
	else { print F "# rsync = ???\n\n"; print "\n\n===> ATTENTION: RSYNC NOT FOUND !\n\n"; }

	print F "targets = 212.43.194.74::backups\n\n"; 		# Par dfaut, on backupe sur Tardenois

	print F "# Liste des fichiers/rpertoires  backuper\n\n";

	if (`uname` eq "FreeBSD\n")
	{
		$host =~ tr/a-z/A-Z/;

		print F "/boot/loader.conf\n";
		print F "/boot/kernel.conf\n";
		print F "\n";
		print F "/etc/crontab\n";
		print F "/etc/passwd\n";
		print F "/etc/master.passwd\n";
		print F "/etc/group\n";
		print F "/etc/sysctl.conf\n";
		print F "/etc/rc.conf\n";
		print F "/etc/periodic.conf\n";
		print F "/etc/make.conf\n";
		print F "/etc/cvsupfile\n";
		print F "/etc/sysctl.conf\n";
		print F "/etc/resolv.conf\n";
		print F "/etc/inetd.conf\n";
		print F "/etc/fstab\n";
		print F "\n";
		print F "/usr/local/share/snmp/snmpd.conf\n";
		print F "\n";
		print F "/usr/local/etc/postfix\n";
		print F "!/usr/local/etc/postfix/*.db\n";
		print F "!/usr/local/etc/postfix/SAMPLES\n";
		print F "\n";
		print F "/usr/local/etc/rc.d\n";
		print F "\n";
		print F "$t/backups.conf\n";
		print F "\n";
		print F "# /usr/src/sys/i386/conf/$host\n";
		print F "\n";
	}
	elsif (`uname` eq "Linux\n")
	{
		print F "/etc/network/interfaces\n";
		print F "/etc/crontab\n";
		print F "/etc/passwd\n";
		print F "/etc/shadow\n";
		print F "/etc/group\n";
		print F "/etc/gshadow\n";
		print F "/etc/postfix\n";
		print F "/etc/aliases\n";
		print F "/etc/inetd.conf\n";
		print F "/etc/motd\n";
		print F "/etc/fstab\n";
		print F "\n";
		print F "/usr/local/Claranet/Configs-Backups/backups.conf\n";
		print F "\n";
	}

	close F;
}

chmod 0600, 'backups.conf';

# Termin.

chmod 0500, '.';

print "\n\nOK !\n\n";

chdir($old_cwd) or die "Can't chdir back to $old_cwd: $!\n";

unlink("./sc.pl") or die "Can't unlink(sc.pl): $!\n";

print "(Script sc.pl supprim).\n\n";

exit 0;

