<?

#	Script de gnration de graphe pour les statistiques de dlais de dlivraisons des emails.
#
#	Yann GROSSEL - 2003.07.03
#

$m_host = 'localhost';				# Host de la base de donnes MySQL  utiliser
$m_base = 'mail_stats';				# Nom  de la base de donnes MySQL  utiliser
$m_user = 'mail_stats';				# User MySQL  utiliser
$m_pass = 'gpRccQ6VE4';				# Password de l'user mysql

$width = 470;							# Largeur totale de l'image  gnrer
$height = 130;							# Hauteur totale de l'image  gnrer

$clip_x1	= 55;							# x1 pour le rectangle contenant le graphique
$clip_x2 = 400 + $clip_x1;			# x2 pour le rectangle contenant le graphique

$clip_y1 = 10;							# y1 pour le rectangle contenant le graphique
$clip_y2 = 110;						# y2 pour le rectangle contenant le graphique

#####

function dump_error($msg)
{
	# Gnre une image contenant un message d'erreur (en cas de probleme)

	global $im, $white, $red, $blue, $width, $height;
	imagestring($im, 5, 10, $height / 2 - 10, $msg, $red);
	imagerectangle($im, 3, 3, $width - 4, $height - 4, $blue);
	imagepng($im);
	imagedestroy($im);
	exit(0);
}

function conv_secs($secs)
{
	$r = '';

	if ($secs < 60)
	{
		# Temps infrieur  une minute.

		if ($secs)	$r = $secs . 's';
		else			$r = '0';
	}
	else if ($secs < 3600)
	{
		# Temps infrieur  une heure.

		if ($secs % 60)	$r = sprintf('%02ds', ($secs % 60));
		$secs /= 60;
		$r = ((int) $secs) . "m$r";
	}
	else if ($secs < 86400)
	{
	 	# Temps infrieur  un jour.
		# On laisse tomber les secondes. On n'affiche que les heures / minutes.

		$secs /= 60;		# On transforme en minutes.
		if ($secs % 60)	$r = sprintf('%02dm', ($secs % 60));
		$secs /= 60;
		$r = ((int) $secs) . "h$r";
	}
	else
	{
		# Temps suprieur  un jour.
		# On laisse tomber les secondes et les minutes. On n'affiche que les jours / heures.

		$secs /= 3600;		# On transforme en heures.
		if ($secs % 24)	$r = ($secs % 24) . 'h';
		$secs /= 24;
		$r = ((int) $secs) . "j$r";
	}

	return str_pad($r, 6, ' ', STR_PAD_LEFT);
}

#####

if (!$_GET['debug'])
	header("Content-type: image/png");

# Initialisations.

$im = imagecreatetruecolor($width, $height);

$white  = imagecolorallocate($im, 255, 255, 255);
$black  = imagecolorallocate($im, 0, 0, 0);
$red    = imagecolorallocate($im, 255, 0, 0);
$grey_1 = imagecolorallocate($im, 242, 242, 242);
$grey_2 = imagecolorallocate($im, 200, 200, 200);
$grey_3 = imagecolorallocate($im, 150, 150, 150);
$blue   = imagecolorallocate($im, 0, 0, 224);

$style = array($black, $grey_1, $grey_1);
imagesetstyle($im, $style);

# On remplit l'image de gris, et on trace la bordure "3D".

imagefill($im, 0, 0, $grey_1);

imageline($im, 0, 0, $width - 2, 0, $grey_2);
imageline($im, 0, 1, $width - 3, 1, $grey_2);

imageline($im, 0, 0, 0, $height - 2, $grey_2);
imageline($im, 1, 0, 1, $height - 3, $grey_2);

imageline($im, 1, $height - 2, $width - 1, $height - 2, $grey_3);
imageline($im, 0, $height - 1, $width - 1, $height - 1, $grey_3);

imageline($im, $width - 2, 1, $width - 2, $height - 1, $grey_3);
imageline($im, $width - 1, 0, $width - 1, $height - 1, $grey_3);

# Vrification des paramtres passs en GET.

# daily:			1 pixel =  5 minutes	: 400 pixels = 33h20m =   120000 secondes
# weekly:		1 pixel = 30 minutes : 400 pixels = 8j8h   =   720000 secondes
# monthly:		1 pixel =  2  heures : 400 pixels = 33j8h	 =  2880000 secondes
# yearly:      1 pixel =  1    jour : 400 pixels = 400j   = 34560000 secondes

$types  = array(           'day',             'week',              'month',              'year');
$tables = array('day' => 'daily', 'week' => 'weekly', 'month' => 'monthly', 'year' =>  'yearly');
$past   = array('day' =>  120000, 'week' =>   720000, 'month' =>   2880000, 'year' =>  34560000);
$lines  = array('day' =>     300, 'week' =>     1800, 'month' =>      7200, 'year' =>     86400);

if (!isset($_GET['source']))
	dump_error("Missing 'source' parameter !");

if (!isset($_GET['type']))
	dump_error("Missing 'type' parameter !");

$type = $_GET['type'];

if (!in_array($type, $types))
	dump_error("Unknown type '$type' !");

$source = (int) $_GET['source'];

$scale == (isset($_GET['scale']));

# Connexion  la base de donnes.

if (!($sql = @mysql_connect($m_host, $m_user, $m_pass)))
	dump_error("Connexion au serveur MySQL impossible !");

if (!mysql_select_db($m_base, $sql))
	dump_error("`USE $m_base' impossible !");

# On rcupre le dernier timestamp disponible dans la base pour la source. En passant on vrifie
# que la source existe bien dans la base...

$r = mysql_query("SELECT max(ts) FROM " . $tables[$type] . " WHERE source_id = $source", $sql);
$a = mysql_fetch_row($r);

if ($a[0] == '')
 dump_error("No data for source '$source' !");

$ts = $a[0];						# Dernier timestamp pour la source.

if (($ts + 600) < time()) {	# Si le timestamp en question est vieux de plus de 10 minutes,
$ts = time(); }					# on force au TS courant.

if ($scale)
	# On prend la valeur maximum toutes sources confondues.
	$r = mysql_query("SELECT max(value) FROM " . $tables[$type] . " WHERE ts >= " . ($ts - $past[$type]));
else
	# On prend la valeur maximum pour la source seulement
	$r = mysql_query("SELECT max(value) FROM " . $tables[$type] . " WHERE source_id = $source AND ts >= " . ($ts - $past[$type]));

$a = mysql_fetch_row($r);
$max = $a[0];

if (!$max)
	dump_error("Only null values for source '$source' !");

$q_w = $clip_x2 - $clip_x1;		# Largeur du quadrillage
$q_h = $clip_y2 - $clip_y1;		# Hauteur du quadrillage

# Calcul de l'chelle verticale. Tous les calculs se font en secondes.

if ($max < (60 * 8))								# Max infrieur  8 minutes
	$max = ceil($max / 10) * 10;				# On prend les 10 secondes suprieures ou gales
else if ($max < (3600 * 5))					# Max infrieur  5 heures
	$max = ceil($max / 60) * 60;				# On prend la minute suprieure
else if ($max < 86400)							# Max infrieur  1 jour
	$max = ceil($max / 3600) * 3600;			# On prend l'heure suprieure

# On trace le quadrillage

$div = $max / $q_h;

# 5 lignes horizontales, suivant l'chelle calcule ci-dessus.

$o = $max / 5;

for ($i = 0; $i <= $max; $i += $o)
{
	$y = $clip_y2 - ($i / $div);
	if ($i && $i < $max)	# On ne trace pas les lignes externes. Le rectangle noir les masquera.
		imageline($im, $clip_x1, $y, $clip_x2, $y, IMG_COLOR_STYLED);
	imagestring($im, 2, $clip_x1 - 40, $y - 6, conv_secs($i), $black);
}

# Lignes verticales : dpendent du type de graphique.

if ($type == 'day')
{
	# 1 ligne par heure, soit une ligne tous les 12 pixels

	# On affiche 33 heures et 20 minutes, pour obtenir 400 pixels, comme mrtg.
	# 33h20 quivaut  120000s
	# 1 ligne par heure. La 1ere ligne doit correspondre  la 1ere heure PLEINE.

	$t = $ts - $past[$type];				# Timestamp au dbut du graphe
	$t -= ($t % 3600);						# Timestamp de l'heure prcdente

	$h = (int) date('G', $t);				# Heure concerne

	$x = $clip_x2 - (($ts - $t) / 300);	# Offset de la 1ere ligne

	for ($i = 0; $i <= 34; $i++)
	{
		if ($x > $clip_x2)
			break;

		if ($x >= $clip_x1)
			imageline($im, $x, $clip_y1, $x, $clip_y2, IMG_COLOR_STYLED);

		if (!($h % 2) && $x >= $clip_x1 - 2)
			imagestring($im, 2, $x - (($h > 9)? 5 : 2), $clip_y2 + 2, $h, $black);

		$x += 12;
		$h += 1; if ($h == 24) $h = 0;
	}
}
else if ($type == 'week')
{
	# 1 ligne par jour, soit une ligne tous les 48 pixels.
	# On affiche 8j8h, pour obtenir 400 pixels, comme mrtg.

	$days = array('Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam');

	$t = $ts - $past[$type];					# Timestamp au dbut du graphe
	$t -= ($t % 86400);							# Timestamp  00:00

	$d = (int) date('w', $t);					# N du jour concern

	$x = $clip_x2 - (($ts - $t) / 1800);	# Offset de la 1ere ligne

	for ($i = 0; $i <= 8; $i++)
	{
		if ($x > $clip_x2)
			break;

		if ($x >= $clip_x1)
			imageline($im, $x, $clip_y1, $x, $clip_y2, IMG_COLOR_STYLED);

		if ($x >= $clip_x1 - 10 && $x < $clip_x2 - 26)
			imagestring($im, 2, $x + 16, $clip_y2 + 2, $days[$d], $black);

		$x += 48;
		$d += 1; if ($d == 7) $d = 0;
	}
}
else if ($type == 'month')
{
	# 1 ligne par semaine, soit une ligne tous les 7 * 12 = 84 pixels.
	# On raisonne par jour (12 * 2h). On trace une ligne tous les 7 jours (le lundi matin).

	$t = $ts - $past[$type];					# Timestamp au dbut du graphe
	$t -= ($t % 86400);							# Timestamp  00:00

	$d = (int) date('w', $t);					# N du jour concern
	$w = (int) strftime('%V', $t);			# N de la semaine. XXX On trouve un n suprieur de 1  celui indiqu par
														# les graphes de MRTG... A creuser (MRTG commence-t-il  0 ?)

	$x = $clip_x2 - (($ts - $t) / 7200);	# Offset de la 1ere ligne

	for ($i = 0; $i <= 34; $i++)
	{
		if ($x > $clip_x2)
			break;

		if ($d == 1 && $x >= $clip_x1)
			imageline($im, $x, $clip_y1, $x, $clip_y2, IMG_COLOR_STYLED);

		if ($d == 3 && $x >= $clip_x1 - 5 && $x < $clip_x2)
			imagestring($im, 2, $x, $clip_y2 + 2, "Sem " . ($w++), $black);

		$x += 12;
		$d += 1; if ($d == 7) $d = 0;
	}
}
else if ($type == 'year')
{
	# 1 ligne par mois, soit une lignes tous les 28  31 pixels. Contrairement aux autres graphes,
	# les lignes ne sont pas rgulires...
	# 400 jours = 13 mois, plus quelques jours.
	# Le plus simple est de tracer les lignes en partant de la fin...

	$months = array('Jan', 'Fv', 'Mar', 'Avr', 'Mai', 'Jui', 'Jul', 'Aou', 'Sep', 'Oct', 'Nov', 'Dec');

	$d = (int) date('d', $ts);							# N du jour  la fin du graphe
	$m = (int) date('m', $ts);							# N du mois  la fin du graphe
	$y = (int) date('Y', $ts);							# N de l'anne  la fin du graphe

	$x = $clip_x2 - $d + 1;								# Position du 1er du mois

	for ($i = 0; $i <= 13; $i++)
	{
		if ($x < $clip_x1)
			break;

		if ($x >= $clip_x1)
			imageline($im, $x, $clip_y1, $x, $clip_y2, IMG_COLOR_STYLED);

		if (--$m == 0) { $m = 12; $y--; }

		imagestring($im, 2, $x - 24, $clip_y2 + 2, $months[$m - 1], $black);

		$x -= date('t', mktime(0, 0, 0, $m, 10, $y));	# On retranche le nombre de jours du mois prcdent.
	}
}

# On trace les valeurs. Il y normalement 400 valeurs  tracer...

$r = mysql_query("SELECT ts, value FROM " . $tables[$type] . " WHERE source_id = $source and ts >= " . ($ts - $past[$type]), $sql);

$found = array();

for ($i = 0; $i < ($clip_x2 - $clip_x1); $i++) { $found[$i] = FALSE; }

# On a : $ts est le ts de la derniere colone  grapher

while ($a = mysql_fetch_row($r))
{
	if ($a[1] == '')		# Si la valeur est NULL, le(s) mail(s) correspondants ne sont pas encore arrivs.
	{
		$color = $red;		# On affiche alors une ligne rouge de hauteur maximum.
		$v = $clip_y1;
	}
	else
	{
		$color = $blue;			# Sinon, on affiche une ligne bleue de hauteur proportiennelle  la valeur...
		$v = ($a[1] / $div);
		$v = $clip_y2 - $v;
	}

	if ($v < 0) $v = 0;

	$p = ($ts - $a[0]) / $lines[$type];

	$found[$clip_x2 - $clip_x1 - $p] = TRUE;

	imageline($im, $clip_x2 - $p, $clip_y2, $clip_x2 - $p, $v, $color);
}

# On place des lignes grises pour les priodes ou l'on a pas de valeurs connues.

for ($i = 0; $i < ($clip_x2 - $clip_x1); $i++)
	if (!$found[$i])
		imageline($im, $clip_x1 + $i, $clip_y2, $clip_x1 + $i, $clip_y1, $grey_2);

imagerectangle($im, $clip_x1, $clip_y1 - 1, $clip_x2 + 1, $clip_y2, $black);

imagepng($im);
imagedestroy($im);

?>
