#! /usr/bin/perl -w

# Ce script analyse un mail envoy par le script send-mail-stats.pl
# qui fonctionne sur flam, a Telehouse 2.

use strict;
use IO::Socket;
require 'sys/syscall.ph';

## Configuration ################

my $target_ip		= "212.43.194.17";		# Adresses IP du serveur (nuala)
my $target_port	= 18820;						# Port UDP  utiliser pour la communication

#################################

# TARGET $target
# WHEN $when
# RELAY $relay
# TIME $start
# GREET $delta_time

sub gettime {
	my $TIMEVAL_T = "LL";
	my $start = pack($TIMEVAL_T, ());
	syscall(&SYS_gettimeofday, $start, 0) != -1 or die "gettimeofday: $!";
	my @v = unpack($TIMEVAL_T, $start);
	return $v[0] + ($v[1] / 1_000_000);
}

my $t = gettime();

my $when = $t;
my $target = '';
my $relay = '';
my $greet = 0;
my $delay = 0;

while (<>)
{
	chomp;

	if (m/^TARGET /) { $_ =~ s/^TARGET //g; $target = $_; next; }
	if (m/^RELAY /)  { $_ =~ s/^RELAY //g; $relay = $_; next; }
	if (m/^WHEN /)   { $_ =~ s/^WHEN //g;  $when = $_; next; }
	if (m/^GREET /)  { $_ =~ s/^GREET //g; $greet = $_; next; }

	if (m/^TIME/)
	{
		$_ =~ m/^TIME ([\d.]+)/;
		$delay = sprintf "%.1f", ($t - $1);
		next;
	}
}

if ($target eq '' or $relay eq '')
{
	# Qu'est-ce que c'est que ce mail ? Il ne contient pas les lements attendu !
	# On quitte.

	exit 0;
}

# Ok, on envoie le message en UDP vers la machine cible.

my $msg = "MAIL-STATS-R $when $target $relay $delay $greet\n";

my $handle = IO::Socket::INET->new(Proto => 'udp') or die "socket: $@";

my $ipaddr   = inet_aton($target_ip);
my $portaddr = sockaddr_in($target_port, $ipaddr);

# Debugs pour essayer de localiser le problme (mails de retours indiquant "cannot send")
if (not defined($handle))		{ die "\$handle not defined ?!"; }
if (not defined($msg))			{ die "\$msg not defined ?!"; }
if (not defined($portaddr))	{ die "\$portaddr not defined ?!"; }

$handle->send($msg, 0, $portaddr) == length($msg) or die "cannot send: $!";

exit 0;

# vim: set ts=3 sw=3:

