#! /usr/bin/perl -w

#
#	sender.pl - Yann GROSSEL 2003.07.01
#
#	Ce script envoie des mails de test afin d'tablir des statistiques / graphes
#	des dlais ncessaires aux transferts des emails.
#
#	Les emails sont envoys toutes les 5 minutes.
#
#	Les emails envoys contiennent le timestamp exact (suivant l'heure de la machine)
#	auquel l'email est envoy.
#
#	Les emails envoys contiennent aussi le timestamp de l'heure d'intgration des donnes,
#	c'est  dire dire le timestamp ajust  5 minutes prs par dfaut. Ainsi mme si la
#	machine mttrice rame, et envoie les emails plusieurs secondes aprs l'heure prvue,
#	les donnes seront quand mme intgres pour l'heure prvue.
#

use strict;
use Net::SMTP;
use IO::Socket;
use Time::Local;

require 'sys/syscall.ph';

## Configuration ################

my $target_ip		= "212.43.194.17";		# Adresses IP du serveur (nuala)
my $target_port	= 18820;						# Port UDP  utiliser pour la communication

#################################

sub gettime {
	my $TIMEVAL_T = "LL";
	my $start = pack($TIMEVAL_T, ());
	syscall(&SYS_gettimeofday, $start, 0) != -1 or die "gettimeofday: $!";
	my @v = unpack($TIMEVAL_T, $start);
	return $v[0] + ($v[1] / 1_000_000);
}

sub send_email($$$$)
{
	my ($smtp, $start, $send);

	my $ts = shift;			# Timestamp
	my $host = shift;			# Serveur SMTP  utiliser (hostname)
	my $serv = shift;			# Adresse IP du serveur  utiliser (si == '', le hostname est utilis)
	my $target = shift;		# Adresse email cible

	if ($serv eq '') { $serv = $host; }

	# Envoi du mail.

	$start = gettime();

	print "Connecting to $serv...\n" if (-t 0);

	$smtp = Net::SMTP->new($serv, ('Hello' => 'ns2.fr.clara.net'));

	print "FAILED !\n" if (-t 0 and not defined($smtp));

	return if not defined($smtp);

	$smtp->mail('mail-stats-sender@sri.fr.clara.net') || return;
	$smtp->to($target) || return;

	$send = gettime();

	my $delta = sprintf "%.4f", $send - $start;

	$smtp->data() || return;
	$smtp->datasend("To: yg\@fr.clara.net\n") || return;
	$smtp->datasend("Subject: Stats SMTP Test\n") || return;
	$smtp->datasend("\n") || return;
	$smtp->datasend("TARGET $target\n") || return;			# Adresse de destination de l'email
	$smtp->datasend("RELAY $host\n") || return;				# Serveur SMTP utilis pour l'envoi (hostname)
	$smtp->datasend("WHEN $ts\n") || return;					# Timestamp de l'heure d'envoie prvue (toutes les 5 minutes)
	$smtp->datasend("TIME $start\n") || return;				# Timestamp exact de l'heure de l'envoi
	$smtp->datasend("GREET $delta\n") || return;				# Temps entre le dbut de la connexion SMTP et l'envoi de "DATA"
	$smtp->dataend();

	$smtp->quit() || return;

	# Ici on est sur que le mail est parti. On envoie un message UDP pour le confirmer au serveur.

	print "Mail sent, sending UDP ACK.\n" if (-t 0);

	my $msg = "MAIL-STATS-M $ts $target $host\n";

	$::handle->send($msg, 0, $::portaddr) == length($msg) or die "cannot send: $!";
}

my ($sec, $min, $hour, $mday, $mon, $year, undef, undef, undef) = localtime(time);

#	On ajuste la minute au multiple de 5 infrieur.

$min -= ($min % 5);

my $ts = timelocal(0, $min, $hour, $mday, $mon, $year);

# On envoie un paquet UDP sur le serveur de Nuala pour qu'il sache que les mails
# vont commencer  partir (on pourra ainsi grapher les mails non arrivs).

my $msg = "MAIL-STATS-S $ts\n";

$::handle   = IO::Socket::INET->new(Proto => 'udp') or die "socket: $@";

my $ipaddr  = inet_aton($target_ip);
$::portaddr = sockaddr_in($target_port, $ipaddr);

$::handle->send($msg, 0, $::portaddr) == length($msg) or die "cannot send: $!";

# Envoi des emails  diffrents domaines, en passant par diffrents relais.
# La table sources de la base mail_stats doit etre a jour pour que cela fonctionne.

# Arguments : Timestamp, Serveur SMTP  utiliser (hostname), Adresse IP du serveur  utiliser (si == '', le hostname est utilis),
# et Adresse email cible.

send_email($ts, 'charentes.fr.clara.net',       '',              'mail-stats@fr.clara.net');
send_email($ts, 'roussillon.fr.clara.net',      '',              'mail-stats@fr.clara.net');
send_email($ts, 'aquitaine.fr.clara.net',       '',              'mail-stats@fr.clara.net');
send_email($ts, 'ardeche.fr.clara.net',         '',              'mail-stats@fr.clara.net');
send_email($ts, 'meuse-av.fr.clara.net',        '212.43.194.61', 'mail-stats@fr.clara.net');
send_email($ts, 'isere-av.fr.clara.net',        '212.43.194.44', 'mail-stats@fr.clara.net');

send_email($ts, 'charentes.fr.clara.net',       '',              'mail-stats@claranet.fr');
send_email($ts, 'roussillon.fr.clara.net',      '',              'mail-stats@claranet.fr');
send_email($ts, 'aquitaine.fr.clara.net',       '',              'mail-stats@claranet.fr');
send_email($ts, 'ardeche.fr.clara.net',         '',              'mail-stats@claranet.fr');

send_email($ts, 'charentes.fr.clara.net',       '',              'mail-stats@sri.fr.clara.net');
send_email($ts, 'roussillon.fr.clara.net',      '',              'mail-stats@sri.fr.clara.net');
send_email($ts, 'aquitaine.fr.clara.net',       '',              'mail-stats@sri.fr.clara.net');
send_email($ts, 'ardeche.fr.clara.net',         '',              'mail-stats@sri.fr.clara.net');
send_email($ts, 'meuse-av.fr.clara.net',        '212.43.194.61', 'mail-stats@sri.fr.clara.net');
send_email($ts, 'isere-av.fr.clara.net',        '212.43.194.44', 'mail-stats@sri.fr.clara.net');

send_email($ts, 'meuse-smtp.fr.clara.net',      '212.43.194.59', 'mail-stats@sri.fr.clara.net');
send_email($ts, 'meuse-smtp.fr.clara.net',      '212.43.194.59', 'mail-stats@claranet.fr');
send_email($ts, 'isere-smtp.fr.clara.net',      '212.43.194.39', 'mail-stats@sri.fr.clara.net');
send_email($ts, 'isere-smtp.fr.clara.net',      '212.43.194.39', 'mail-stats@claranet.fr');

send_email($ts, 'mendez.freesurf.fr',           '',              'mail-stats@freesurf.fr');
send_email($ts, 'fidel.freesurf.fr',            '',              'mail-stats@freesurf.fr');
send_email($ts, 'bastille.freesurf.fr',         '212.43.206.26', 'mail-stats@freesurf.fr');
send_email($ts, 'danton.freesurf.fr',           '',              'mail-stats@freesurf.fr');

# Termin.

exit 0

# vim: set ts=3 sw=3:

